#!/bin/sh
PID=`pidof Wicard_1.19`
OSD="Wicard - 1.19"
Action=$1

cam_clean () {
		rm -rf /tmp/*.info*	/tmp/*.tmp*
}

cam_handle () {
		if test	-z "${PID}"	; then
				cam_up;
		else
				cam_down;
		fi;
}

cam_down ()	{
		killall	Wicard_1.19
		sleep 2
		cam_clean
}

cam_up () {
		/usr/bin/cam/Wicard_1.19 -c  /etc/tuxbox/config/wicardd/wicardd.conf &
}

if test	"$Action" =	"cam_res" ;	then
		cam_down
		cam_up
elif test "$Action"	= "cam_down" ; then
		cam_down
elif test "$Action"	= "cam_up" ; then
		cam_up
else
		cam_handle
fi

exit 0
