#!/bin/sh
#################################################
##### The script is used for suspending currently running cam on standby #####
##### or starting previously suspended cam on resume ################
##### Author: ktoto ####################################
#################################################

CAM_SUSPENDED='/var/script/cam_suspended'

case "$1" in
	start)
  # Start prevously suspended cam on resume
  if [ -f $CAM_SUSPENDED ]; then
    # read stored cam script name of previously suspended cam
    CAM_SCRIPT=`head -n 1 $CAM_SUSPENDED`
    # get a list of all available cam scripts by reading /var/script/ folder
    # and match stored cam script name of previously suspended cam
    # cam scripts mask is *_cam.sh
    if [ `ls -1 /var/script/*_cam.sh | grep "$CAM_SCRIPT"` ]; then
      # start previously suspended cam
      $CAM_SCRIPT start &
    else
      echo $CAM_SCRIPT is not a valid cam script.
    fi
  fi
  ;;
  stop)
  # Suspend running cam on standby to save traffic
  # get a list of all available cam scripts by reading /var/script/ folder
  # cam scripts mask is *_cam.sh
  for i in `ls -1 /var/script/*_cam.sh`
  do 
    CAM_SCRIPT=$i
    # extract only cam name (process name) without the full path and _cam.sh suffix
    CAM_NAME=`basename $CAM_SCRIPT _cam.sh`
    # find all pids for running cam
    CAM_PID=`pidof $CAM_NAME`
    # in case if running cam has many pids, the first one will do just fine
    if [ `echo $CAM_PID | cut -d " " -f 1` ]; then
      echo $CAM_SCRIPT>$CAM_SUSPENDED
      # suspend running cam
      $CAM_SCRIPT stop &
    fi
  done
  ;;
	*)
	$0 stop
	exit 0
	;;
esac

exit 0
