#!/bin/sh

echo
echo "##################################################"
echo "     NEXT DEVICE IS CONNECTED TO YOU IPBOX "
echo "##################################################"
/sbin/fdisk -l
echo "##################################################"

etc_folder=/etc
net_folder=/etc/network

echo "-----------------------------------------------"
echo "       ### Step1 ( SELECT DEVICE ) ###"
echo "-----------------------------------------------"
echo "   Please, select device for installation !    "
echo "       Example: sda or sdb or sdc              "
echo " ATTENTION:Only drive without partition number!"
echo "-----------------------------------------------"
read q1
target=$q1

echo "-----------------------------------------------"
echo "Image name? (example:IscanMod_E2_v802.tar.gz)"
read s1

echo "-----------------------------------------------"
echo "You ipbox ip-address? (example:192.168.1.5)"
read s2

echo "-----------------------------------------------"
echo "You network mask? (example:255.255.255.0)"
read s3

echo "-----------------------------------------------"
echo "Gateway/router ip-adress? (example:192.168.1.1)"
read s4

echo "-----------------------------------------------"
echo "DNS1? (example:192.168.1.1)"
read s5

echo "-----------------------------------------------"
echo "DNS2? (example:192.168.1.2 or xxx.yyy.zzz.rrr) "
echo "(Set dns you internet provider or not input it)"
read s6

echo "-----------------------------------------------"
echo "Logical Partition number?"
echo
echo "If you wont clean install" 
echo "on new disk-press 1"
echo
echo "If you wont not formated you device"
echo "and have configure usb/hdd device"
echo "select you old-images partition number"  
read s7
echo "-----------------------------------------------"


#################### Configuration Options NOT CHANGE IT ######################

image_name=$s1		# Image name
tuner_ip=$s2		# Set Ip_address for you tuner
network_mask=$s3	# You network mask
gateway_ip=$s4   	# You gateway Ip_address
dns1=$s5		# You DNS1 adress
dns2=$s6		# You DNS2 adress
folder=e2		# Folder in /mnt for unpack E2
partition=$s7		# Partition number on device

##################################################################


####################### NOT CHANGE IT !!! ##########################
echo "-----------------------------------------"
echo "You configuration setting is correct?  "
echo "-----------------------------------------"
echo
echo "image_name="$image_name
echo "tuner_ip="$tuner_ip
echo "network_mask="$network_mask
echo "gateway="$gateway_ip
echo "dns1="$dns1
echo "dns2="$dns2
echo "folder=/mnt/"$folder
echo "target device="$target
echo
echo "----------------------------------"
echo
echo "      INFORMATION IS CORRECT ?"
echo
echo "------ Please, press Y or N ------"

read z1
case $z1 in
        y|Y) echo "----- Begin instalation -----" ;;
        n|N) exit;       ;;
esac


##################### UMOUNT OLD MOUNTPOINT ######################

cd /
umount /media
umount /hdd
umount /mnt/hdd
umount /mnt/usb/usb0
umount /mnt/usb/usb1
umount /mnt/usb/usb2
echo 



##################### FORMAT DEVICE  ##############################

echo "-----------------------------"
echo "   ### Step2 ( fdisk ) ###   "
echo "-----------------------------"
echo "Clear disk space (fdisk) ?"
echo "Press Y - if do fdisk"
echo "Press N - next step  "
echo "Press E - exit script "
echo "-----------------------------"
read z2
case $z2 in
        y|Y) /sbin/fdisk /dev/$target < /tmp/format.txt > /dev/null ;;
        n|N) echo "### Load next:### " ;;
        e|E) exit; ;;
esac


echo "### DISK PARTITION ### "
/sbin/fdisk -l /dev/$target
sleep 1

#################### CREATE EXT2 ###################################
echo
echo "-----------------------------"
echo "### Step3 (mkfs to ext2) ### "
echo "-----------------------------"
echo "Format partition in ext2 ?"
echo "Press Y - if do mkfs device"
echo "Press N - next step"
echo "Press E - exit script"
echo "-----------------------------"
read z3
case $z3 in
        y|Y) /sbin/mkfs.ext2 /dev/$target$partition ;;
        n|N) echo "### Load next:### "      ;;
        e|E) exit; ;;
esac

############## CREATE FOLDER FOR E2 UNPACK ###########################

if [ ! -e /mnt/$folder ]; then
mkdir /mnt/$folder
chmod 777 /mnt/$folder
fi
echo "folder in [ /mnt/"$folder" ] is created"
ls /mnt


mount /dev/$target$partition /mnt/$folder
df
cd /mnt/$folder

############# UNPACK IMAGES IN SOURCE FOLDER ##################

echo
echo "-------------------------------------"
echo "     ### Step4 (PUT IMAGES) ###"
echo "-------------------------------------"
echo "    Please FTP-connect you IPBOX "
echo " and put you images in /mnt/"$folder 
echo "     Press Y if you do it "
echo "   or press E for exit script"
echo "-------------------------------------"

read z4
case $z4 in
        y|Y) tar xzf $image_name ;;
        e|E) exit; ;;
esac

########### SETUP NETWORK SETTINGS #############

### delete long boot ###
rm -f /mnt/$folder/var/config/cifs_on

### configure dns servers ###
rm -f /mnt/$folder$etc_folder/resolv.conf
echo nameserver $dns1 >> /mnt/$folder$etc_folder/resolv.conf
echo nameserver $dns2 >> /mnt/$folder$etc_folder/resolv.conf
chmod 777 /mnt/$folder$etc_folder/resolv.conf

### configure network settings ###
rm -f /mnt/$folder$net_folder/interfaces
echo auto lo >> /mnt/$folder$net_folder/interfaces
echo iface lo inet loopback >> /mnt/$folder$net_folder/interfaces
echo  >> /mnt/$folder$net_folder/interfaces
echo auto eth0 >> /mnt/$folder$net_folder/interfaces
echo iface eth0 inet static >> /mnt/$folder$net_folder/interfaces
echo address $tuner_ip >> /mnt/$folder$net_folder/interfaces
echo netmask $network_mask >> /mnt/$folder$net_folder/interfaces
echo gateway $gateway_ip>> /mnt/$folder$net_folder/interfaces

######### UMOUNT AFTER SETUP #################

sleep 2

cd /
umount /mnt/$folder
echo "--------------------------------------------------------"
df
echo "--------------------------------------------------------"
echo
echo "If you devise is umount in /mnt/e2"
echo "Please Poweroff you ipbox"
echo "After PowerUp press 15s enigma-key for you remoute pults"
echo "--------------------------------------------------------"
echo "FINISH!"
